import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import { BookOpen, Book, GraduationCap, Baby, Search } from 'lucide-react'
import './BookBook.css'

const genres = [
  { id: 'fiction', name: 'Художественная', icon: BookOpen },
  { id: 'science', name: 'Научная', icon: Book },
  { id: 'textbook', name: 'Учебная', icon: GraduationCap },
  { id: 'children', name: 'Детская', icon: Baby }
]

function BookBook() {
  const navigate = useNavigate()
  const [selectedGenre, setSelectedGenre] = useState(null)
  const [bookTitle, setBookTitle] = useState('')

  const handleSubmit = (e) => {
    e.preventDefault()
    
    if (!selectedGenre || !bookTitle.trim()) {
      alert('Пожалуйста, выберите жанр и введите название книги')
      return
    }

    const orders = JSON.parse(localStorage.getItem('libraryOrders') || '{"active": [], "past": []}')
    const genreName = genres.find(g => g.id === selectedGenre)?.name || selectedGenre
    
    const returnDate = new Date()
    returnDate.setDate(returnDate.getDate() + 14)

    const newOrder = {
      id: Date.now(),
      title: bookTitle.trim(),
      genre: genreName,
      returnDate: returnDate.toISOString().split('T')[0],
      status: 'active'
    }

    orders.active.push(newOrder)
    localStorage.setItem('libraryOrders', JSON.stringify(orders))
    
    navigate('/')
  }

  return (
    <div className="book-book">
      <div className="page-header">
        <h1>Забронировать книгу</h1>
        <p>Выберите жанр и введите название книги</p>
      </div>

      <form className="booking-form" onSubmit={handleSubmit}>
        <div className="form-section">
          <h2 className="section-title">
            <BookOpen className="section-icon" size={24} />
            Выберите жанр
          </h2>
          <div className="genres-grid">
            {genres.map(genre => {
              const IconComponent = genre.icon
              return (
                <button
                  key={genre.id}
                  type="button"
                  className={`genre-card ${selectedGenre === genre.id ? 'selected' : ''}`}
                  onClick={() => setSelectedGenre(genre.id)}
                >
                  <div className="genre-icon">
                    <IconComponent className="genre-icon-img" size={40} />
                  </div>
                  <span className="genre-name">{genre.name}</span>
                </button>
              )
            })}
          </div>
        </div>

        <div className="form-section">
          <h2 className="section-title">
            <Search className="section-icon" size={24} />
            Название книги
          </h2>
          <input
            type="text"
            className="book-input"
            placeholder="Введите название книги..."
            value={bookTitle}
            onChange={(e) => setBookTitle(e.target.value)}
          />
        </div>

        <button type="submit" className="submit-btn">
          Забронировать
        </button>
      </form>
    </div>
  )
}

export default BookBook

